package tv.twitch.starshot64.util

import android.animation.Animator
import android.animation.AnimatorListenerAdapter
import android.view.View

/**
 * Helper function for cross fading two views
 *
 * Ideally should be used on two opaque views that are the same size (ideally both taking up the full screen)
 */
fun crossFadeViews(oldView: View, newView: View, duration: Long) {
  // Fade in the new view
  newView.apply {
    alpha = 0f
    visibility = View.VISIBLE

    animate().alpha(1f).setDuration(duration).setListener(null)
  }

  // Fade out the old view
  oldView.apply {
    alpha = 1f
    visibility = View.VISIBLE
    requestFocus()

    animate().alpha(0f).setDuration(duration)
      .setListener(object : AnimatorListenerAdapter() {
        override fun onAnimationEnd(animation: Animator?) {
          oldView.clearFocus()
          oldView.visibility = View.GONE
          newView.requestFocus()
        }
      })
  }
}
