# Debugging

## Web Debugging

The web application running inside of the `WebView` on the device can be
connected to and debugged using Chrome Dev Tools on your development machine.
See [this page](https://developer.amazon.com/docs/fire-tv/webapp-debug-app.html)
for setup instructions.

There are multiple scenarios to consider:

- Load the production app
- Load from a staging environment
- Load from developer machine

The general setup is:

- Build the app in a debug configuration
- Use Android Debug Bridge to connect to the device
  - `adb connect <device-ip>`
- Launch the app on the device
  - This may be done from the command line or in Android Studio
  - If you want to point at your localhost or a staging environment you must
    pass in a custom web app host, for example:
    - `--es "starshot-host" "192.168.1.142"`
  - In Android Studio you can modify the launch arguments for the `app-staging`
    launch configuration.
- Navigate to the inspect page in Chrome
  - Enter `chrome://inspect`
  - You should then see the running application listed
- Click `inspect` under the desired application
  - A new Dev Tools window should open to debug the application in realtime

**Note**: You do not have to be debugging in Android Studio in order to debug
the web app using Chrome. In fact, if the native application is on a breakpoint
in Android Studio the Chrome Dev Tools will not respond until the application
resumes in Android Studio.

## Native Debugging

Java, Kotlin and C/C++ can be debugged using Android Studio. Build and launch
the app on the target device using the Debug button. Breakpoints should work and
you should be able to inspect the callstacks of threads.
