# Environment Setup

## Android Studio

- Use [Android Studio](https://developer.android.com/studio) to run the native
  app shell on virtual or physical Android/Fire TV devices.

- From Android Studio, open the Tachyon repo from tachyon/native-apps/androidtv
  as the root of the project.

- Follow [these instructions](../aws-cli-and-aws-secrets.md) to set up the AWS
  cli for secret management. This is required for Sentry to upload Proguard
  mappings.

- Use [Ktlint](https://ktlint.github.io/) for Kotlin formatting.

#### Tips

- You can select the app shell configuration and the build variant
  (amazon=firetv/google=androidtv, debug/release/shipping)

### Virtual Device Setup

- Click AVD Manager in the top right of the window.
- Select `Create Virtual Device...`
- Select TV device category and create an Android TV device.
- Pick your OS
- Finish the rest of the setup as desired

You can select the device to build for at the top of the window.

_Note: You will probably get an error when gradle syncs saying unable to find
`:app` or something similar. This means you are missing the correct SDK for your
virtual OS. Go to preferences->Appearance & Behavior->System Settings->Android
SDK and download the missing SDK matching your virtual OS._
