# GraphQL

The native shell uses GraphQL in the implementation of the recommendations
service that supplies Twitch tiles to the Android dashboard. The GraphQL
pipeline used here is independent from that of the Starshot web application.

## GraphQL in Native

The native code uses [Apollo](https://www.apollographql.com/docs/android/) for
querying GraphQL. The repo contains a copy of the current GraphQL schema, and
any time this is updated, we will need to update the copy in our repo, as this
is used for auto-generating query code.

### Adding new queries to the native app

Query files are saved with the `*.graphql` file extension, and should all be
located in `<app_root>/app/src/main/graphql/tv/twitch`.

Any time you need to modify the schema file or add/remove/modify a query, you'll
need to run the following command from the application project directory to
generate updated source files:

`./gradlew generateApolloSources`

This step is also done automatically when you build the project, but you may
notice that Android Studio will complain about missing methods or fields.
