# Android Recommendations

Android TV and Fire TV both expose an API for creating shelves of content (also
known as channels in Android nomenclature) on the device home screen. Because
these channels are present even when the user is not in our app, they provide a
highly visible and ever present means to remind people of what content exists on
Twitch and serve as a good way to keep people coming back to our app.

This document outlines the intended functionality both for people outside the TV
Apps engineering team who want to understand how we populate these rows or for
other engineers to understand how this system should be working in case you need
to fix bugs in it or modify it.

## High Level Recommendation Flow

Recommendations are fetched on a periodic basis in the background using an
Android JobService. This job scheduled once when our app is launched, and then
continues to run while our app is in the background. Our application registers a
boot receiver which will attempt to restart the job if we detect that the device
has rebooted.

After installing the app it must be launched once in order to install the
service hooks in the system. If you do not launch the app, even if you reboot it
will not run the recommendations service that updates the rows. In the event
that the user force quits their app, this will stop the job from running until
the app is launched again. This also receives notifications of the system
language/region changing, so that we can fetch recommendations in the
appropriate language.

## Update Frequency

The recommendations rows in the Android home screen are configured to update
every 15 minutes. This is the minimum interval allowed for Android background
services.

## Deeplink Referrer Ids

```
tt_medium=android-shelf
```

## For (All Fire TV devices) and (Android TV device versions older than Android O):

```
tt_content=legacy_launcher_recommended_streams
```

### For Android TV O or higher

For the recommended streams row:

```
tt_content=launcher_recommended_streams
```

For the followed games row:

```
tt_content=launcher_recommended_games
```

For the watch next row:

```
tt_content=launcher_watch_next
```

## Screenshots

Here's what the recommendations look like on different devices in different
states.

### Fire TV Home Tab Recommendation Row

Home Tab Recommendation Row:

![Fire TV Home Tab Recommendation Row](doc/images/firetv_recs.jpg)

Live Tab Recommendation Row (note that it only contains Twitch content and also
displays a preview image in the top right corner):

![Fire TV Live Tab Recommendation Row](doc/images/firetv_live.jpg)

### Android TV Version O or higher

Logged out:

![Logged Out](doc/images/loggedoutchannels.jpg)

Logged in (note that the play next row only appears when logged in):

![Logged Out](doc/images/loggedinchannels.jpg)

Enabling and disabling channels:

![Configuring channels](doc/images/channelsempty.jpg)
