#!/bin/bash
# Syntax: ./build.sh
# Dependency: Docker
# This will build the AndroidTV application locally using the Docker workflow

DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

docker build --tag starshot-android -f $DIR/../../Dockerfile.androidtv $DIR/..

docker run -v $DIR/../..:/opt/tachyon/native-apps \
--rm \
starshot-android \
/bin/bash -c "cd /opt/tachyon/native-apps/androidtv && ktlint \"!**/generated/**\""
retVal=$?
if [ $retVal -ne 0 ]; then
    echo "AppShell ktlint failed: $retVal"
    exit $retVal
fi

docker run -v $DIR/../..:/opt/tachyon/native-apps \
--rm \
starshot-android \
/bin/bash -c "cd /opt/tachyon/native-apps/androidtv && ./gradlew assembleShipping"
retVal=$?
if [ $retVal -ne 0 ]; then
    echo "AppShell build failed: $retVal"
    exit $retVal
fi

mkdir -p credentials
aws sts get-session-token > credentials/aws.json

AWS_SECRET_ACCESS_KEY=`grep SecretAccessKey credentials/aws.json | cut -d'"' -f4`
AWS_ACCESS_KEY_ID=`grep AccessKeyId credentials/aws.json | cut -d'"' -f4`
AWS_SESSION_TOKEN=`grep SessionToken credentials/aws.json | cut -d'"' -f4`

docker run --env AWS_SECRET_ACCESS_KEY=$AWS_SECRET_ACCESS_KEY \
--env AWS_ACCESS_KEY_ID=$AWS_ACCESS_KEY_ID \
--env AWS_SESSION_TOKEN=$AWS_SESSION_TOKEN \
--env SANDSTORM_NO_CREDENTIALS_PROFILE=1 \
-v $DIR/../..:/opt/tachyon/native-apps/ starshot-android \
/bin/bash -c "cd /opt/tachyon/native-apps/androidtv && scripts/sign_apk.sh"
retVal=$?
if [ $retVal -ne 0 ]; then
    echo "AppShell signing failed: $retVal"
    exit $retVal
fi

rm credentials/aws.json
