# Fetch the Sentry auth token json using the AWS CLI. Then trim the json payload down to the auth token.
# If the auth token fetch fails then error out or warning depending on build type
# Append the credentials to the sentry-auth.properties file for usage in env variables for symbol upload.
# sentry-auth.properties is never uploaded to github so the key will be secure even for failed builds

authToken=$(AWS_REGION=us-east-2 AWS_PROFILE=tvapps-prod aws secretsmanager \
  get-secret-value --secret-id SentryAuthTokenEmp | jq .SecretString | sed 's/\\//g' \
  | sed -E 's/^"|"$//g' | jq .sentry_auth_token_emp | tr -d \")

if [[ -z $authToken ]]
then
  if [[ "$2" = "Shipping" ]]
  then
  # Hard fail out
   echo "Error fetching Sentry auth token secret, most likely missing AWS credentials. Follow the steps here: \
   https://git.xarth.tv/pages/emerging-platforms/tachyon/d/native-apps/aws-cli-and-aws-secrets.md"
   echo "ERROR: Build Failing"
   exit 1 # arbitrary error code
  else
   # Soft error message
   echo "Error fetching Sentry auth token secret, most likely missing AWS credentials. Follow the steps here: \
   https://git.xarth.tv/pages/emerging-platforms/tachyon/d/native-apps/aws-cli-and-aws-secrets.md"
   echo "WARNING: Build will continue without Sentry Proguard symbol upload"
  fi
else
  echo """sentrytemp.org=twitch
sentrytemp.project=$1
sentrytemp.authtoken=${authToken}""" >> ../sentry-auth.properties
fi
