# AWS CLI and Isengard Helper Tool for AWS Secret Management

You must install the AWS CLI and Isengard helper to enable secret management
with AWS secrets. Sentry needs this in order to upload symbols for Proguard
during build.

1. Install the
   [AWS CLI](https://docs.aws.amazon.com/cli/latest/userguide/install-cliv2.html)
2. Download the
   [Isengard Credentials Script](https://git.xarth.tv/twitch/isengard_credentials)

   1. Clone the repo
      `git clone git@git.xarth.tv:twitch/isengard_credentials.git`
   2. Either add the `isengard_credentials` executable to your PATH or move it
      to somewhere in your PATH such as bin:
      ```
      mv isengard_credentials/isengard_credentials /usr/local/bin
      ```
   3. Add this to `~/.aws/credentials`
      ```
      [tvapps-prod]
      credential_process = isengard_credentials --account-id 969432690216 --role admin
      ```
