#pragma once

#include <functional>
#include <map>
#include <string>
#include <vector>

enum class HttpRequestType { Get, Put, Post, Delete };

struct HttpParam {
  HttpParam(const std::string &name, const std::string &value);
  HttpParam(const std::string &name, int value);

  std::string paramName;
  std::string paramValue;
};

using HeaderMap = std::map<std::string, std::string>;
using HttpRequestHeadersCallback = std::function<bool(uint32_t statusCode, const HeaderMap &headers, void *userData)>;
using HttpRequestCallback = std::function<void(uint32_t statusCode, const std::vector<char> &body, void *userData)>;

/**
 * Synchronously sends the HTTP request.  If communication with the server succeeds then the status and
 * response will be reported via the callbacks and true will be returned.  Otherwise, false will be returned.
 * This is to be implemented by the application so that this will be found at link-time.
 */
bool SendHttpRequest(const std::string &requestName, const std::string &url,
  const std::vector<HttpParam> &requestHeaders, const uint8_t *requestBody, size_t requestBodySize,
  HttpRequestType httpReqType, uint32_t timeOutInSecs, const HttpRequestHeadersCallback &headersCallback,
  const HttpRequestCallback &responseCallback, void *userData);
