#pragma once

#include "core/httprequest.hpp"

#include <sstream>

std::string BuildUrlEncodedRequestParams(const std::vector<std::pair<std::string, std::string>> &requestParams);
std::string BuildUrlEncodedRequestParams(const std::vector<HttpParam> &requestParams);
std::string BuildUrlEncodedRequestParams(const std::map<std::string, std::string> &requestParams);
std::string BuildHttpHeader(const std::vector<HttpParam> &headerParams);
bool ContainsHttpParameter(const std::vector<HttpParam> &headers, const std::string &name);
void UrlEncode(const std::string &inputString, std::stringstream &outputStream);
std::string UrlEncode(const std::string &inputString);
void UrlDecode(const std::string &inputString, std::stringstream &outputStream);
void UrlDecode(const std::string &input, std::string &result);
std::string UrlDecode(const std::string &inputString);

void SplitHttpParameters(const std::string &parameterString, std::vector<std::pair<std::string, std::string>> &result);
void SplitHttpParameters(const std::string &parameterString, std::map<std::string, std::string> &result);

constexpr bool Is2XX(uint32_t statusCode) {
  return statusCode >= 200 && statusCode <= 299;
}
constexpr bool Is3XX(uint32_t statusCode) {
  return statusCode >= 300 && statusCode <= 399;
}
constexpr bool Is4XX(uint32_t statusCode) {
  return statusCode >= 400 && statusCode <= 499;
}
constexpr bool Is5XX(uint32_t statusCode) {
  return statusCode >= 500 && statusCode <= 599;
}

/**
 * Generate all possible hosts (i.e. by removing subdomains) for a given
 * hostname. Example: chat.twitch.tv -> {chat.twitch.tv, *.twitch.tv,
 * twitch.tv}.
 */
bool GenerateSslVerificationHosts(const std::string &originalHost, std::vector<std::string> &result);

/**
 * Returns whether or not a given hostname is in the format of a 32-bit IPv4
 * address. Checks for dotted decimal representation (a.b.c.d). Does not check
 * if the IP address is valid (will still return true even if numbers > 255).
 */
bool IsHostAnIpAddress(const std::string &hostName);
