#pragma once

#include <condition_variable>

#include <mutex>

/**
 * A simple threading construct that ensures a thread waiting on a signal will not proceed until the signal has been
 * fired. It is valid to call Fire() before the waiting thread calls Wait() and will allow the waiting thread to
 * proceed.
 *
 * This is a one-time use class.
 */
class Signal {
 public:
  Signal();
  ~Signal();

  Signal(const Signal& rhs) = delete;
  Signal& operator=(const Signal& rhs) = delete;

  void Wait();
  void Fire();

 private:
  std::mutex mMutex;
  std::condition_variable mCondition;
  bool mFired;
};
