#pragma once

#include "core/eventqueue.hpp"

#include <atomic>
#include <thread>

/**
 * An eventScheduler that runs and drives itself in a background thread.
 *
 * Shutdown() should be called before the ThreadedEventScheduler is destroyed.
 * Additionally, clients should wait for the shutdownTask lambda to be called back before destroying the
 * ThreadedEventScheduler.
 *
 * ScheduleTask() and CancelTask() should not be called after ThreadedEventScheduler is shut down.
 */
class ThreadedEventScheduler {
 public:
  ThreadedEventScheduler();
  ~ThreadedEventScheduler();

  enum class EventSchedulerState { Running, ShuttingDown, ShutDown };

  TaskId ScheduleTask(TaskParams&& taskParams);
  bool CancelTask(TaskId taskId);
  bool Shutdown(TaskFunc&& shutdownTask);
  EventSchedulerState GetState() const { return mState; }

 private:
  void EventSchedulerThreadProc();

 private:
  std::unique_ptr<std::thread> mThread;
  EventQueue mEventQueue;
  TaskFunc mShutDownTask;
  std::atomic<EventSchedulerState> mState;
};
