#pragma once

#include "core/threadedeventscheduler.hpp"
#include "core/time.hpp"
#include "tracking/trackingevents.hpp"

#include <chrono>
#include <sstream>

/**
 * Provides the main tracking service functionality.
 */
class TrackingAPI {
 public:
  TrackingAPI(ThreadedEventScheduler& scheduler);
  ~TrackingAPI();

  /**
   * Retrieves the URL used to send tracking events to the backend.
   */
  std::string GetSpadeUrl() const;

  /**
   * Enqueues an event for reporting.
   */
  void TrackEvent(TrackingEvent&& event);

 private:
  void EnqueueFailedEvents(uint32_t& numDropped, std::vector<std::string>& inFlightEvents);
  bool IsFlushScheduled() const { return mFlushTaskId != 0; }
  void ScheduleNextFlushIfNeeded(bool isAfterFlush, bool flushSucceeded = true);
  void FlushEvents();

  ThreadedEventScheduler& mScheduler;
  RetryBackoffTable mBackoffTable;
  /**
   * The batch that is currently being filled.
   */
  std::vector<std::string> mPendingEvents;

  /**
   * The max number of bytes allowed in an encoded batch.  This is a value
   * dictated by backend.
   */
  size_t mMaxBytesInBatch;
  /**
   * The max number of events that can be kept around waiting to be sent.
   */
  uint32_t mMaxPendingEvents;
  std::chrono::milliseconds mFlushInterval;

  std::mutex mMutex;
  /**
   * The task ID of the currently scheduled flush.
   */
  TaskId mFlushTaskId;
  bool mShutdown;
};
