#pragma once

#include <json11/json11.hpp>

class TrackingEvent {
 public:
  std::string clientApp;
  std::string language;
  std::string osName;
  std::string osVersion;
  std::string twitchAppVersion;
  std::string twitchDeviceId;
  std::string twitchPlatform;

 private:
  std::string context;
  std::string subContext;
  std::map<std::string, json11::Json> payload;
  int time;

 protected:
  TrackingEvent(const std::string& context, const std::string& subContext = "");

 public:
  void SetPayloadValue(const std::string& key, json11::Json::object&& value) { payload[key] = value; }
  void SetPayloadValue(const std::string& key, int value) { payload[key] = value; }
  void SetPayloadValue(const std::string& key, float value) { payload[key] = value; }
  void SetPayloadValue(const std::string& key, const std::string& value) { payload[key] = value; }

  /**
   * Builds a JSON object from the event data.
   */
  json11::Json ToJson();

  /**
   * Creates a JSON object from the properties.  This should be overridden if the concrete event
   * has additional properties.
   */
 protected:
  json11::Json::object PropertiesToJson();
};

class NativeShellLaunchTrackingEvent : public TrackingEvent {
 public:
  NativeShellLaunchTrackingEvent() : TrackingEvent("launch") {}
};

class NativeShellLoginTrackingEvent : public TrackingEvent {
 public:
  NativeShellLoginTrackingEvent() : TrackingEvent("login") {}
};

class NativeShellLogoutTrackingEvent : public TrackingEvent {
 public:
  NativeShellLogoutTrackingEvent() : TrackingEvent("logout") {}
};

class NativeShellErrorTrackingEvent : public TrackingEvent {
 public:
  NativeShellErrorTrackingEvent(const std::string& error) : TrackingEvent("error", error) {}
};
