#include "core/signal.hpp"

Signal::Signal() : mFired(false) {}

Signal::~Signal() {
  Fire();
}

void Signal::Wait() {
  std::unique_lock<std::mutex> lock(mMutex);

  mCondition.wait(lock, [this] { return mFired; });
}

void Signal::Fire() {
  {
    std::unique_lock<std::mutex> lock(mMutex);
    if (mFired) {
      return;
    }
    mFired = true;
  }

  mCondition.notify_all();
}
