#include "core/stringutilities.hpp"

#include <array>
#include <chrono>
#include <iomanip>
#include <limits>
#include <sstream>

int IsWhitespace(int ch) {
  return ch == ' ' || ch == '\t' || ch == '\r' || ch == '\n';
}

std::string ToLowerCase(const std::string &str) {
  std::string lower = str;
  (void)std::transform(lower.begin(), lower.end(), lower.begin(), ::tolower);
  return lower;
}

void Trim(std::string &str) {
  // trim leading and trailing whitespace
  // TODO: Test this out!
  (void)str.erase(str.begin(), std::find_if(str.begin(), str.end(), [](unsigned char c) { return !IsWhitespace(c); }));
  (void)str.erase(
    std::find_if(str.rbegin(), str.rend(), [](unsigned char c) { return !IsWhitespace(c); }).base(), str.end());
}

void Split(const std::string &str, std::vector<std::string> &result, char sep, bool includeEmpty) {
  unsigned start = 0;
  unsigned end = 0;

  for (;;) {
    if (end == str.size() || str[end] == sep) {
      if (end > start || includeEmpty) {
        result.push_back(str.substr(start, end - start));
      }

      if (end == str.size()) {
        break;
      }

      ++end;
      start = end;
    } else {
      ++end;
    }
  }
}

void Split(const std::string &str, const std::string &delim, std::vector<std::string> &result) {
  if (delim == "") {
    result.push_back(str);
    return;
  }

  std::string scratch = str;

  while (!scratch.empty()) {
    size_t index = scratch.find(delim);

    // Found a delimeter
    if (index != std::string::npos) {
      // Don't push empty tokens
      if (index > 0) {
        result.push_back(scratch.substr(0, index));
      }

      // Remove the token and the trailing delimeter
      scratch.erase(0, index + delim.size());
    }
    // No delimeters, the rest of the string is a token
    else {
      result.push_back(scratch);

      break;
    }
  }
}

bool EndsWith(const std::string &str, const std::string &suffix) {
  if (str.size() < suffix.size()) {
    return false;
  }

  std::string tail = str.substr(str.size() - suffix.size(), suffix.size());

  return tail == suffix;
}
