#include "tracking/trackingevents.hpp"

#include "core/time.hpp"

#include <chrono>
#include <ctime>

TrackingEvent::TrackingEvent(const std::string& context, const std::string& subContext)
    : context(context), subContext(subContext), time(GetSecondsSinceEpoch()) {}

json11::Json TrackingEvent::ToJson() {
  json11::Json::object map;
  map["event"] = "native_shell_event";
  map["context"] = context;

  if (!subContext.empty()) {
    map["subcontext"] = subContext;
  }

  auto properties = PropertiesToJson();
  map["properties"] = properties;

  return json11::Json(std::move(map));
}

json11::Json::object TrackingEvent::PropertiesToJson() {
  json11::Json::object result;

  result["app_version"] = twitchAppVersion;
  result["client_app"] = clientApp;
  result["device_id"] = twitchDeviceId;
  result["language"] = language;
  result["os_name"] = osName;
  result["os_version"] = osVersion;
  result["platform"] = twitchPlatform;
  result["time"] = time;

  if (!payload.empty()) {
    result["payload"] = payload;
  }

  return result;
}
