# General Windows Environment Setup

1. Make sure you have ran [Kevin's script](./static-docfiles/onboarding.ps1) in
   administrator powershell which will install git and other useful dev
   environment tools onto your system.
1. [Install Teleport Bastion: Teleport](https://wiki.xarth.tv/display/CAP/General+Windows+Environment+Setup#:~:text=Teleport%20Bastion%23QuickStart)
   (May not be needed with new work from home changes)
1. Complete the
   [Git enterprise setup](https://wiki.xarth.tv/display/DTA/Connecting+to+GHE-Github+Enterprise)
   for:
   - git Operations over SSH
1. Clone the `twitch-apps/tachyon` repository
1. `cd tachyon`

### `tachyon/scripts/setup` does not run on windows so follow these steps instead:

1. Setup nvm by downloading and running `nvm-setup.zip` from
   [here](https://github.com/coreybutler/nvm-windows/releases)
1. Set the proper node version by running `nvm use 14.15.5` or any 14.15.X
   version in git bash
1. Set the yarn version by running `yarn set version 1.22.10` in git bash
   - If you have issues with yarn being version `1.22.5` and you cannot change
     it, then uninstall yarn with `npm uninstall -g yarn` and then install the
     nightly yarn windows build from
     [here](https://classic.yarnpkg.com/en/docs/install/#windows-nightly)
1. Run `yarn install` from tachyon root in git bash

_Adapted from
[General Windows Environment Setup](https://wiki.xarth.tv/display/CAP/General+Windows+Environment+Setup)_
