# Laser Array

A portable CSR app for launching [Starshot](../../apps/starshot/README.md)
within native TV apps.

## Overview

Laser Array checks that Starshot is available from its health check endpoint. If
the health check fails, a styled error page will be displayed (via the static
HTML bundle) allowing the user to reload the page and try again.

This prevents the user from getting a non-app looking error which would be
unexpected in a TV app.

## Development

Laser Array is powered by [Create React App](https://create-react-app.dev).

### Dev Mode

Run it locally with `yarn start`. The `.env` specifies the following defaults:

- `PUBLIC_URL` to set relative paths (required when serving from file system
  such as LG).
- `REACT_APP_GIT_COMMIT` for error logging
- `REACT_APP_SENTRY_DSN`for Sentry reports
- `REACT_APP_STARSHOT_URL` for specifying which Starshot app to hit (it can be a
  local URL or a remote staging / production URL)

### Prod Mode

Run `yarn prodlike` to run Laser Array with a production build.

## Production Usage

The WebOS build process builds Laser Array, supplying:

- `REACT_APP_GIT_COMMIT`
- `REACT_APP_STARSHOT_URL`

## Accessing Error Logs

Error logs are sent to
[Sentry](https://sentry.io/organizations/twitch/issues/?project=5236805)
