const configurator = require('../../jest.configurator');

module.exports = configurator({
  // https://jestjs.io/docs/en/webpack.html#handling-static-assets
  moduleNameMapper: {
    '\\.(jpg|ico|jpeg|png|gif|eot|otf|webp|svg|ttf|woff|woff2|mp4|webm|wav|mp3|m4a|aac|oga)$':
      '<rootDir>/__mocks__/fileMock.js',
  },
  setupFiles: ['./setupTests.ts'],
  setupFilesAfterEnv: ['./setupTestsAfterEnv.ts'],
  transform: {
    '^.+\\.tsx?$': ['babel-jest', { cwd: __dirname }],
  },
});
