/**
 * This script bundles all locale messages into a single object.
 */
import { readFileSync, writeFileSync } from 'fs';
import { join } from 'path'
import { SUPPORTED_LOCALE_DATA } from 'tachyon-intl';

const MESSAGE_DIR = join(__dirname, '../messages');
const MESSAGE_FILE = 'messages.json';
const OUT = join(__dirname, '../public/localeMessages.js');

const locales = SUPPORTED_LOCALE_DATA.map(data => {
  const messages = data.languageCode === 'en'
    ? undefined
    : JSON.parse(readFileSync(join(MESSAGE_DIR, data.languageCode, MESSAGE_FILE)).toString());

  return {
    data: {
      locale: data.locale,
      messages,
    },
    ...data,
  }
});

writeFileSync(OUT, `window.locales = ${JSON.stringify(locales, null, 2)};`)
