import type { FC } from 'react';
import { exhaustedCase } from 'tachyon-utils';
import { Mode, useLaserArrayConfig } from '../../components';
import { ErrorPage, StarshotLoaderPage } from '../../pages';

/**
 * Determines how to render the page based on the active mode that is specified
 * in the query parameters.
 */
export const LaserArrayPageRenderer: FC = () => {
  const config = useLaserArrayConfig();
  switch (config.mode) {
    case Mode.Full: {
      break;
    }
    case Mode.NativeError: {
      return <ErrorPage />;
    }
    default: {
      exhaustedCase(config.mode, null);
    }
  }

  return <StarshotLoaderPage />;
};

LaserArrayPageRenderer.displayName = 'LaserArrayPageRenderer';
