import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { Mode } from '../../components';
import { ErrorPage, StarshotLoaderPage } from '../../pages';
import { LaserArrayPageRenderer } from '.';

let mockMode: Mode = Mode.Full;

jest.mock('../../components', () => ({
  ...jest.requireActual('../../components'),
  useLaserArrayConfig: () => ({
    mode: mockMode,
  }),
  useLaserArrayNativeAppProxy: () => {
    return null;
  },
}));

describe(LaserArrayPageRenderer, () => {
  const setup = createShallowWrapperFactory(LaserArrayPageRenderer, () => ({}));

  it('renders Full mode', () => {
    mockMode = Mode.Full;
    const { wrapper } = setup();
    expect(wrapper.find(ErrorPage)).not.toExist();
    expect(wrapper.find(StarshotLoaderPage)).toExist();
  });

  it('renders NativeError mode', () => {
    mockMode = Mode.NativeError;
    const { wrapper } = setup();
    expect(wrapper.find(ErrorPage)).toExist();
    expect(wrapper.find(StarshotLoaderPage)).not.toExist();
  });
});
