import { configureClientLogging, logger } from 'tachyon-logger';
import {
  BUILD_ID,
  CLIENT_APP,
  NODE_ENV,
  PLATFORM,
  SENTRY_DSN,
} from '../../config';

// istanbul ignore next: high cost low value
export function configure(): void {
  const language = navigator.language;
  const appEnvironment = NODE_ENV;

  logger.debug({
    category: 'configure',
    context: {
      appEnvironment,
      buildId: BUILD_ID,
      language,
      platform: PLATFORM,
    },
    message: 'Configuring application',
    package: CLIENT_APP,
  });

  if (NODE_ENV === 'production') {
    // configure error reporting (this should happen first/asap)
    try {
      configureClientLogging({
        appEnvironment,
        appSentryDsn: SENTRY_DSN,
        buildId: BUILD_ID,
        language,
        platform: PLATFORM,
      });
    } catch {
      // If this fails still try to start the app, don't bother logging though
      // since our logger isn't shipping logs.
    }
  }
}
