import type { FC } from 'react';
import { EnvironmentRoot } from 'tachyon-environment';
import { useIntl } from 'tachyon-intl';
import {
  BUILD_ID,
  CLIENT_APP,
  OFFLINE_DETECTION_WAIT_MS,
  PLATFORM,
} from '../../../config';

export const LaserArrayEnvironmentRoot: FC = ({ children }) => {
  const intl = useIntl();
  return (
    <EnvironmentRoot
      children={children}
      common={{
        appEnvironment: 'production',
        appVersion: BUILD_ID,
        clientApp: CLIENT_APP,
        language: intl.getActiveLocale() ?? 'en-US',
        platform: PLATFORM,
      }}
      networkStatusDebounceWait={OFFLINE_DETECTION_WAIT_MS}
    />
  );
};

LaserArrayEnvironmentRoot.displayName = 'LaserArrayEnvironmentRoot';
