import type { FC } from 'react';
import { EventReporterRoot } from 'tachyon-event-reporter';
import { Mode, useLaserArrayConfig } from '../../../components';
import { SPADE_BATCH_WINDOW_MS, SPADE_URL } from '../../../config';

// istanbul ignore next: trivial
export const LaserArrayEventReporterRoot: FC = ({ children }) => {
  const { mode } = useLaserArrayConfig();
  const spadeConfig =
    mode === Mode.Full
      ? { batchWindowMs: SPADE_BATCH_WINDOW_MS, spadeUrl: SPADE_URL }
      : undefined;
  return <EventReporterRoot children={children} spade={spadeConfig} />;
};

LaserArrayEventReporterRoot.displayName = 'LaserArrayEventReporterRoot';
