import type { FC } from 'react';
import { useStaticEnvironment } from 'tachyon-environment';
import { useReportEvent } from 'tachyon-event-reporter';
import { EventTrackerRoot } from 'tachyon-event-tracker';

// istanbul ignore next: trivial
export const LaserArrayEventTrackerRoot: FC = ({ children }) => {
  const reportEvent = useReportEvent();
  const { client, common } = useStaticEnvironment();

  return (
    <EventTrackerRoot
      children={children}
      onEvent={reportEvent}
      staticProperties={{
        appVersion: common.appVersion,
        clientApp: common.clientApp,
        deviceID: client.deviceID,
        language: common.language,
        netInfo: client.netInfo,
        platform: common.platform,
        sessionID: client.sessionID,
      }}
    />
  );
};

LaserArrayEventTrackerRoot.displayName = 'LaserArrayEventTrackerRoot';
