import type { FC } from 'react';
import { useStaticEnvironment } from 'tachyon-environment';
import { useCustomTracking } from 'tachyon-event-tracker';
import type { LatencyEvent } from 'tachyon-latency-tracker';
import { LatencyTrackerRoot } from 'tachyon-latency-tracker';
import { Mode, useLaserArrayConfig } from '../../../components';
import { DEFAULT_ROUTENAME } from '../../../config';

// istanbul ignore next: trivial
export const LaserArrayLatencyTrackerRoot: FC = ({ children }) => {
  const trackEvent = useCustomTracking<LatencyEvent>();
  const { client } = useStaticEnvironment();
  const { mode } = useLaserArrayConfig();
  const disableLatencyTracking = mode !== Mode.Full;

  return (
    <LatencyTrackerRoot
      children={children}
      currentLocation={DEFAULT_ROUTENAME}
      currentPath={'/'}
      disableLatencyTracking={disableLatencyTracking}
      onEvent={trackEvent}
      sessionID={client.sessionID}
    />
  );
};

LaserArrayLatencyTrackerRoot.displayName = 'LaserArrayLatencyTrackerRoot';
