import type { FC } from 'react';
import styled from 'styled-components';
import { TachyonIntlRoot } from 'tachyon-intl';
import type { ClientSideErrorBoundaryProps } from 'tachyon-more-ui';
import {
  ClientSideErrorBoundary,
  CoreUiSsrRoot,
  ScFonts,
  ScTvStyles,
} from 'tachyon-more-ui';
import {
  LaserArrayConfigRoot,
  LaserArrayNativeAppProxyRoot,
} from '../components';
import { ErrorPage } from '../pages';
import { LaserArrayPageRenderer } from './LaserArrayPageRenderer';
import { configure } from './configure';
import {
  LaserArrayEnvironmentRoot,
  LaserArrayEventReporterRoot,
  LaserArrayEventTrackerRoot,
  LaserArrayLatencyTrackerRoot,
} from './contextRootAdapters';

configure();

const ScMain = styled.main`
  height: 100vh;
  width: 100vw;
`;

// istanbul ignore next: trivial
export const App: FC = () => {
  // We put all of the locales on the window rather than lazy loading them like you'd do in a larger CSR app.
  const locales = window.locales;

  const commonErrorBoundaryProps: Pick<
    ClientSideErrorBoundaryProps,
    'app' | 'errorStateComponent' | 'isDevelopment'
  > = {
    app: 'laser-array',
    errorStateComponent: ErrorPage,
    isDevelopment: process.env.NODE_ENV === 'development',
  };

  return (
    <>
      <ScFonts />
      <ScTvStyles />
      <CoreUiSsrRoot appRootElementId="root" disableHoverCSS theme="dark">
        <ScMain>
          <ClientSideErrorBoundary
            {...commonErrorBoundaryProps}
            boundaryName="LaserArrayRootBoundary"
          >
            <TachyonIntlRoot
              data={{
                locales,
                // not all laser-array targets have this API
                // eslint-disable-next-line @typescript-eslint/no-unnecessary-condition
                preferredLanguageTags: navigator.languages?.slice() ?? [
                  navigator.language,
                ],
              }}
            >
              <LaserArrayEnvironmentRoot>
                <LaserArrayConfigRoot>
                  <LaserArrayEventReporterRoot>
                    <LaserArrayEventTrackerRoot>
                      <LaserArrayLatencyTrackerRoot>
                        <ClientSideErrorBoundary
                          {...commonErrorBoundaryProps}
                          boundaryName="LaserArrayAppBoundary"
                        >
                          <LaserArrayNativeAppProxyRoot>
                            <LaserArrayPageRenderer />
                          </LaserArrayNativeAppProxyRoot>
                        </ClientSideErrorBoundary>
                      </LaserArrayLatencyTrackerRoot>
                    </LaserArrayEventTrackerRoot>
                  </LaserArrayEventReporterRoot>
                </LaserArrayConfigRoot>
              </LaserArrayEnvironmentRoot>
            </TachyonIntlRoot>
          </ClientSideErrorBoundary>
        </ScMain>
      </CoreUiSsrRoot>
    </>
  );
};

App.displayName = 'App';
