import type { FC } from 'react';
import { createContext, useContext, useMemo } from 'react';
import { Mode, parseModeQueryParam } from './parseModeQueryParam';

export * from './parseModeQueryParam';

export interface LaserArrayConfig {
  readonly mode: Mode;
}

const laserArrayConfigContext = createContext<LaserArrayConfig>({
  mode: Mode.Full,
});

/**
 * Parses the URL and makes known parameters available.
 */
export const LaserArrayConfigRoot: FC = ({ children }) => {
  const ctx: LaserArrayConfig = useMemo<LaserArrayConfig>(
    () => ({
      mode: parseModeQueryParam(),
    }),
    [],
  );

  return <laserArrayConfigContext.Provider children={children} value={ctx} />;
};
LaserArrayConfigRoot.displayName = 'LaserArrayConfigRoot';

/**
 * Obtains a LaserArrayConfig instance, assuming LaserArrayConfigRoot is
 * an ancestor in the DOM.
 */
export const useLaserArrayConfig = (): LaserArrayConfig => {
  return useContext(laserArrayConfigContext);
};
