import { logger } from 'tachyon-logger';
import { Mode, parseModeQueryParam } from '.';

jest.mock('tachyon-logger', () => ({ logger: { error: jest.fn() } }));

function testModeParam(modeParam: string | undefined): Mode {
  let search: string;
  if (modeParam) {
    search = `?mode=${modeParam}`;
  } else {
    search = '';
  }

  delete (window as any).location;
  (window as any).location = { search };

  return parseModeQueryParam();
}

// Save the original window.location value
const { location: originalWindowLocation } = window;

describe('parseModeQueryParam', () => {
  // Restore the original window.location values
  afterEach(() => {
    (window.location.search as any) = originalWindowLocation;
  });

  it('parses missing mode parameter correctly', () => {
    const mode = testModeParam(undefined);
    expect(mode).toBe(Mode.Full);
    expect(logger.error).toHaveBeenCalled();
  });

  it('parses explicit full mode correctly', () => {
    const mode = testModeParam('full');
    expect(mode).toBe(Mode.Full);
    expect(logger.error).not.toHaveBeenCalled();
  });

  it('parses explicit native-error mode correctly', () => {
    const mode = testModeParam('native-error');
    expect(mode).toBe(Mode.NativeError);
    expect(logger.error).not.toHaveBeenCalled();
  });
});
