import { createMountWrapperFactory } from 'tachyon-test-utils';
import { parseModeQueryParam } from './parseModeQueryParam';
import { LaserArrayConfigRoot } from '.';

jest.mock('tachyon-logger', () => ({ logger: { error: jest.fn() } }));

jest.mock('./parseModeQueryParam', () => {
  const original = jest.requireActual('./parseModeQueryParam');
  return {
    ...original,
    parseModeQueryParam: jest.fn(original.parseModeQueryParam),
  };
});

const mockParseModeQueryParam = parseModeQueryParam as jest.Mock;

describe('LaserArrayConfigRoot', () => {
  it('retrieves the current mode query params', () => {
    createMountWrapperFactory(LaserArrayConfigRoot)();
    expect(mockParseModeQueryParam).toHaveBeenCalledTimes(1);
  });
});
