import type { FC } from 'react';
import { createContext, useContext, useMemo } from 'react';
import { useStaticEnvironment } from 'tachyon-environment';
import type { LaserArrayNativeProxy } from '../proxies';
import {
  createLaserArrayNativeAppProxy,
  createLaserArrayStubNativeAppProxy,
} from '../proxies';

// istanbul ignore next: trivial
export const nativeAppProxyContext = createContext<LaserArrayNativeProxy>(
  createLaserArrayStubNativeAppProxy(),
);

/**
 * Root object to provide access to a native proxy interface that is platform-specific.
 * This must exist somewhere under a LaserArrayEnvironmentRoot.
 */
// istanbul ignore next: trivial
export const LaserArrayNativeAppProxyRoot: FC = ({ children }) => {
  const {
    common: { platform },
  } = useStaticEnvironment();

  const ctx = useMemo<LaserArrayNativeProxy>(
    () => createLaserArrayNativeAppProxy(platform),
    [platform],
  );

  return <nativeAppProxyContext.Provider children={children} value={ctx} />;
};

LaserArrayNativeAppProxyRoot.displayName = 'LaserArrayNativeAppProxyRoot';

/**
 * Obtains a LaserArrayNativeAppProxyContext instance, assuming LaserArrayNativeAppProxyRoot is
 * an ancestor in the DOM.
 */
// istanbul ignore next: trivial
export const useLaserArrayNativeAppProxy = (): LaserArrayNativeProxy => {
  return useContext(nativeAppProxyContext);
};
