import type {
  LaserArrayNativeBrowserWindowProxy,
  LaserArrayNativeProxy,
} from './proxy';

// NOTE: On Android TV and Fire TV window.androidTvNativeHooks will be set by the native
// application code when running on the client.
declare global {
  interface Window {
    androidTvNativeHooks: LaserArrayNativeBrowserWindowProxy | undefined;
  }
}

/**
 * Creates an implementation of LaserArrayNativeProxy which wraps the native interface for Android/Fire TV.
 */
export function createLaserArrayAndroidNativeAppProxy(): LaserArrayNativeProxy {
  return {
    laserArrayErrorRetry: () => {
      // defense against the IPC API changing
      // eslint-disable-next-line @typescript-eslint/no-unnecessary-condition
      window.androidTvNativeHooks?.laserArrayErrorRetry?.();
    },
    nativeProxyType: 'android-hooks',
  };
}
