import { Platform } from 'tachyon-environment';
import { createLaserArrayAndroidNativeAppProxy } from './androidtv';
import { createLaserArrayNintendoSwitchNativeAppProxy } from './nintendo-switch';
import type { LaserArrayNativeProxy } from './proxy';
import { createLaserArrayStubNativeAppProxy } from './stub';

/**
 * Uses environment state to determine the appropriate proxy type and instantiate it.
 */
export function createLaserArrayNativeAppProxy(
  platform: Platform,
): LaserArrayNativeProxy {
  switch (platform) {
    case Platform.AndroidTV:
    case Platform.FireTV:
      return createLaserArrayAndroidNativeAppProxy();
    case Platform.Switch:
      return createLaserArrayNintendoSwitchNativeAppProxy();
  }
  return createLaserArrayStubNativeAppProxy();
}
