import type { LaserArrayNativeProxy } from './proxy';

export const NINTENDO_SWITCH_ERROR_RETRY_URL =
  'http://localhost/?href=error-retry';

// istanbul ignore next: trivial
/**
 * Creates an implementation of LaserArrayNativeProxy which wraps the native interface for Nintendo Switch.
 */
export function createLaserArrayNintendoSwitchNativeAppProxy(): LaserArrayNativeProxy {
  return {
    /**
     * The Nintendo Switch Offline Web Applet does not let use programmatically navigate to URLs
     * so we need to embed them in the page via an href.
     */
    laserArrayErrorRetry: () => undefined,
    nativeProxyType: 'exit-url',
  };
}
