export type LaserArrayNativeProxyType = 'android-hooks' | 'exit-url' | 'stub';

/**
 * The common interface used between the application and platform specific
 * proxies.
 */
export interface LaserArrayNativeProxy {
  laserArrayErrorRetry: () => void;
  readonly nativeProxyType: LaserArrayNativeProxyType;
}

/**
 * The interface of the object attached to browser window when the Native App Shell
 * supports that proxy mode.
 */
export interface LaserArrayNativeBrowserWindowProxy {
  laserArrayErrorRetry: () => void;
  readonly nativeProxyType: LaserArrayNativeProxyType;
}
