import type { FC } from 'react';
import {
  AlignItems,
  Display,
  JustifyContent,
  Layout,
  LoadingSpinner,
  Position,
  SpinnerSize,
} from 'twitch-core-ui';

/**
 * Delay until spinner shows.
 *
 * nngroup.com/articles/website-response-times/
 */
const DELAY = 1000;

// istanbul ignore next: trivial
export const Loading: FC = () => (
  <Layout
    alignItems={AlignItems.Center}
    attachBottom
    attachLeft
    attachRight
    attachTop
    display={Display.Flex}
    justifyContent={JustifyContent.Center}
    position={Position.Absolute}
  >
    <LoadingSpinner delay={DELAY} size={SpinnerSize.Large} />
  </Layout>
);

Loading.displayName = 'Loading';
