import type { FC } from 'react';
import { useEffect } from 'react';
import { usePageview } from 'tachyon-event-tracker';
import { useLatencyTransitionComplete } from 'tachyon-latency-tracker';
import { LOADING_ROUTENAME } from '../../config';

// istanbul ignore next: trivial
export const Redirect: FC<{ to: string }> = ({ to }) => {
  const reportTransitionComplete = useLatencyTransitionComplete();
  useEffect(() => {
    reportTransitionComplete({ location: LOADING_ROUTENAME });
  });
  usePageview({ location: LOADING_ROUTENAME });
  // transition complete and pageview must come before this redirect effect
  // to avoid being discarded
  useEffect(() => {
    /*
     * after using replace() the current page will not be saved in session
     * history, meaning the user won't be able to use the Back button to
     * navigate to it.
     *  - https://developer.mozilla.org/en-US/docs/Web/API/Location/replace
     *
     * https://jira.twitch.com/browse/MWC-2629
     */
    window.location.replace(to);
  });

  return null;
};

Redirect.displayName = 'Redirect';
