// eslint-disable-next-line istanbul/no-ignore-file
/* istanbul ignore file: config only */
import type { AppEnvironment } from 'tachyon-environment';
import {
  LAUNCHER_VERSION_QUERY_PARAM_KEY,
  Platform,
} from 'tachyon-environment';
import { Enum } from 'tachyon-utils';

/**
 * The platform name.  The supplied string should be an exact match of one
 * of the keys in the Platform enum.
 *
 * See packages/tachyon-core/environment/src/Platform/index.ts
 */
export const PLATFORM =
  Enum.convertValueFromExternal(
    Platform,
    process.env.REACT_APP_STARSHOT_PLATFORM,
  ) ?? Platform.StarshotWeb;

export const CLIENT_APP = 'laser-array';

export const BUILD_ID = `lsr-${process.env.REACT_APP_GIT_COMMIT.slice(0, 7)}`;

/**
 * Hard-coded to the default Spade URL. Assume that our native app isn't going
 * to have to contend with ad-blocking and won't require continuous rotation.
 */
export const SPADE_URL = new URL('https://spade.twitch.tv').href;
// disable batching in laser array due to its short lifespan
export const SPADE_BATCH_WINDOW_MS = 0;

const healthCheckUrl = new URL(process.env.REACT_APP_STARSHOT_URL);
healthCheckUrl.pathname = '_debug/running';
export const HEALTH_CHECK_URL = healthCheckUrl.href;

const starshotLaunchUrl = new URL(process.env.REACT_APP_STARSHOT_URL);
starshotLaunchUrl.searchParams.append(
  LAUNCHER_VERSION_QUERY_PARAM_KEY,
  BUILD_ID,
);
export const STARSHOT_LAUNCH_URL = starshotLaunchUrl.href;

export const DEFAULT_ROUTENAME = 'laser-array';
export const LOADING_ROUTENAME = 'loader';
export const LOADING_ERROR_ROUTENAME = 'loader_error';

export const OFFLINE_DETECTION_WAIT_MS = 2500;

export const SENTRY_DSN = new URL(process.env.REACT_APP_SENTRY_DSN).href;

// eslint-disable-next-line @typescript-eslint/no-unnecessary-condition
export const NODE_ENV = (process.env.NODE_ENV ??
  'development') as AppEnvironment;
