import { useMemo } from 'react';
import {
  Mode,
  useLaserArrayConfig,
  useLaserArrayNativeAppProxy,
} from '../../../components';

type ErrorPageHooks = {
  onRetryClicked: () => void;
};

export const useErrorPageHooks = (): ErrorPageHooks => {
  const { mode } = useLaserArrayConfig();
  const { laserArrayErrorRetry } = useLaserArrayNativeAppProxy();

  return useMemo(() => {
    switch (mode) {
      case Mode.Full: {
        return {
          onRetryClicked: () => {
            window.location.reload();
          },
        };
      }
      case Mode.NativeError: {
        return { onRetryClicked: laserArrayErrorRetry };
      }
    }
  }, [mode, laserArrayErrorRetry]);
};
