import { renderHook } from '@testing-library/react-hooks';
import {
  Mode,
  useLaserArrayConfig,
  useLaserArrayNativeAppProxy,
} from '../../../components';
import { useErrorPageHooks } from '.';

jest.mock('../../../components', () => {
  return {
    ...jest.requireActual('../../../components'),
    useLaserArrayConfig: jest.fn(),
    useLaserArrayNativeAppProxy: jest.fn(),
  };
});

const mockUseLaserArrayConfig = useLaserArrayConfig as jest.Mock;
const mockUseLaserArrayNativeAppProxy =
  useLaserArrayNativeAppProxy as jest.Mock;

describe('ErrorPage', () => {
  const mockReload = jest.fn();
  // we have to fully clear jsdom's stub here
  delete (window as any).location;
  (window as any).location = {
    reload: mockReload,
  };

  beforeEach(() => {
    mockReload.mockReset();
  });

  it('useErrorPageHooks selects correct retry function for Mode.Full', () => {
    mockUseLaserArrayConfig.mockReturnValue({ mode: Mode.Full });
    mockUseLaserArrayNativeAppProxy.mockReturnValue({
      laserArrayErrorRetry: null,
    });

    renderHook(() => {
      const hooks = useErrorPageHooks();
      hooks.onRetryClicked();
    });

    expect(mockReload).toHaveBeenCalledTimes(1);
  });

  it('useErrorPageHooks selects correct retry function for Mode.NativeError', () => {
    const mockRetry = jest.fn();
    mockUseLaserArrayConfig.mockReturnValue({ mode: Mode.NativeError });
    mockUseLaserArrayNativeAppProxy.mockReturnValue({
      laserArrayErrorRetry: mockRetry,
    });

    renderHook(() => {
      const hooks = useErrorPageHooks();
      hooks.onRetryClicked();
    });

    expect(mockRetry).toHaveBeenCalledTimes(1);
    expect(mockReload).not.toHaveBeenCalled();
  });
});
