import type { FC } from 'react';
import { useDynamicEnvironment } from 'tachyon-environment';
import { useIntl } from 'tachyon-intl';
import { ErrorPage } from '../Error';
import { Loader } from './Loader';

export const StarshotLoaderPage: FC = () => {
  const { formatMessage } = useIntl();
  const { isOffline } = useDynamicEnvironment();

  if (isOffline) {
    return (
      <ErrorPage
        message={formatMessage(
          'No internet connection detected, resolve and try again.',
          'InternalServerError',
        )}
      />
    );
  }

  return <Loader />;
};

StarshotLoaderPage.displayName = 'StarshotLoaderPage';
