import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { ErrorPage } from '../Error';
import { Loader } from './Loader';
import { StarshotLoaderPage } from '.';

let mockIsOffline = false;
jest.mock('tachyon-environment', () => ({
  ...jest.requireActual('tachyon-environment'),
  useDynamicEnvironment: () => ({
    isOffline: mockIsOffline,
  }),
}));

describe(StarshotLoaderPage, () => {
  const setup = createShallowWrapperFactory(StarshotLoaderPage);

  beforeEach(() => {
    mockIsOffline = false;
  });

  it('renders the error page when the client is offline', () => {
    mockIsOffline = true;
    const { wrapper } = setup();
    expect(wrapper.find(ErrorPage)).toHaveProp({
      message: 'No internet connection detected, resolve and try again.',
    });
    expect(wrapper.find(Loader)).not.toExist();
  });

  it('renders the loader when the client is online', () => {
    const { wrapper } = setup();
    expect(wrapper.find(ErrorPage)).not.toExist();
    expect(wrapper.find(Loader)).toExist();
  });
});
