# Starshot 64 Nintendo Switch

A thin wrapper application that runs the Twitch TV web app (starshot) on
Nintendo Switch devices.

## Setup

### Requirements

Switch development requires a windows laptop running Visual Studio with the
Tachyon mono-repo pulled down and a Nintendo Developer Portal account.

### Preparing Your Environment

1. Download and install the Nintendo Dev Interface and Nintendo SDK 12.x (near
   bottom of page) from
   [here](https://developer.nintendo.com/group/development/g1kr9vj6/downloads).
1. Prepare the Nintendo Dev Environment
   1. Launch Nintendo Dev Interface (NDI)
   1. Select `Create Dev Environment`
      - `Dev Environments`
      - `Create My Own`
      - `Install To Disk`
      - Select `Nintendo Developer Portal` and enter your Nintendo Developer ID
      - Select `Standard Tool Set`
      - Select the most recent version of the SDK
      - `C:\Nintendo` is fine for location. For name enter `Twitch`
      - Click the top option for SDK only
      - Once installation is finished, click
        `Check the Suitability of the Operating Environment` under
        `Set Up the PC Environment`
   1. Follow
      [the docs](https://developer.nintendo.com/html/online-docs/g1kr9vj6-en/document.html?doc=Packages/SDK/NintendoSDK/Documents/index.html?docname=NintendoSDK%20Documents)
      to initialize the EDEV kit
      - Guide to Setting Up The Environment
      - NX
      - Initializing the EDEV
   1. Return to the `Welcome` in NDI page and select `Hardware`
      - Select the device from the list and click `Start`
      - This will update the firmware on the dev kit and trigger the dev kit to
        restart several times
1. Build The Native App
   - Launch Visual Studio and open a Project/Solution. The .sln can be found in
     `tachyon/native-apps/nintendo-switch/app`.
   - You should see `NX64` as an available build platform. Build the solution in
     release mode.
1. Install The Application On The Dev Kit
   - Launch `Nintendo Target Manager`
   - Right click on the device and select `Connect to Target`
   - Once connected, right click and select `Install Application or Patch`
   - Choose `tachyon\native-apps\nintendo-switch\NX64\Release\Twitch.nsp`
1. Launching the Application
   - Once the application is installed, on the dev kit navigate to `Network`
   - Select `Submit Network Request`. You should be prompted to connect the
     internet, connect to your local wifi network.
   - Return to the dev kit home screen and select `Application` -> `Twitch` and
     then allow the dev kit to create a user profile
   - Starshot should now launch. You can select staging environments by going to
     the settings cog and then naving down to `Environment Selector`

## Debug Settings

You can set some debugging options on the devkit with the following command.

`%NINTENDO_SDK_ROOT%\Tools\CommandLineTools\Settings\SettingsManager.exe Import -r debug_settings.json`

The `debug_settings.json` file has a few options already set up to enable the
Web Inspector and show the memory overlay.

See the following pages for some settings.

- https://developer.nintendo.com/html/online-docs/g1kr9vj6-en/Packages/SDK/NintendoSDK/Documents/Package/contents/Pages/Page_107320698.html
- https://developer.nintendo.com/html/online-docs/g1kr9vj6-en/document.html?doc=https%3A%2F%2Fdeveloper.nintendo.com%2Fhtml%2Fonline-docs%2Fg1kr9vj6-en%2FPackages%2FSDK%2FNintendoSDK%2FDocuments%2FPackage%2Fcontents%2FPages%2FPage_253381544.html

To reset to default settings on the devkit use the following command.

`%NINTENDO_SDK_ROOT%\Tools\CommandLineTools\Settings\SettingsManager.exe Reset -r`

## Web Inspector

Once you have enabled Web Inspector on the devkit using the instruction in the
Debug Settings section you can launch the Web Applet on the devkit remotely by
using the following command on your PC. It will show you a dialog with an IP
address to connect to.

`%NINTENDO_SDK_ROOT%\Tools\CommandLineTools\RunOnTarget.exe %NINTENDO_SDK_ROOT%\TargetTools\NX-NXFP2-a64\WebAppletCaller\Release\WebAppletCaller.nsp -- web https://switch.tv.twitch.tv --user-index 0 --pointer-enabled false --footer-fixed-kind Auto --boot-display-kind Black --background-kind Normal --js-extension-enabled true --media-auto-play-enabled true`

Visit the following URL in your browser or refresh it if you're already there.
Be sure to update the IP address in the URL with the one shown in the dialog on
the Switch. You may need to enable local file access in your browser if you have
issues. Once you have launched the URL in your browser you can dismiss the
dialog on the Switch and it will load up the app sending debug info back to your
browser.

NOTE: Replace `C:/Nintendo/Twitch-12.2.0` with the value of your
`%NINTENDO_SDK_ROOT%` variable.

`file:///C:/Nintendo/Twitch-12.2.0/NintendoSDK/Tools/WebInspector/Web/Resources/Main.html?ws=192.168.1.127:9222/devtools/page/1`

## Useful Documentation

[Player Error Codes](https://developer.nintendo.com/html/online-docs/g1kr9vj6-en/document.html?doc=Packages/Docs/lists/NintendoSwitch-ErrorCodeList/NintendoSwitch-ErrorCodeList-en.html)
