#pragma once

namespace app {
/**
 * Native -> Starshot
 * ~~~~~~~~~~~~~~~~~~
 *   Values are passed into Starshot via the initial URL.
 *
 *   Query params:
 *     ipc-version: The IPC version string.
 *     unique_id: The 32 character device id that is generated on the native side.
 *     allow-chat: Whether or not the app should connect to chat.
 *     context: Passed back to Starshot when it is passed to native vai a callback url that closed the browser.
 *
 *   URL fragments:
 *     access-token: The oauth token, passed in using a fragment so it does not leave the client.
 *     refresh-token: The refresh token, passed in using a fragment so it does not leave the client.
 *
 * Starshot -> Native
 * ~~~~~~~~~~~~~~~~~~
 *   Callbacks are made from Starshot back to the native side by closing the browser with
 *   specific URLs.  When closing the browser and receiving any of these callbacks the
 *   shell will reopen the browser at the home page.
 *
 *   Callbacks:
 *     Login:  https://switch.tv.twitch.tv/_ipc?callback=login&access-token=<token>&refresh-token=<token>&context=<context>
 *     Logout: https://switch.tv.twitch.tv/_ipc?callback=logout&context=<context>
 */
constexpr char kStarshotNativeInterfaceVersion[] = "switch-1";
constexpr char kStarshotIpcCallbackUrlPrefix[] = "https://switch.tv.twitch.tv/_ipc?";

constexpr char kLaserArrayIpcCallbackUrlPrefix[] = "http://localhost/?href=";
}  // namespace app
