#pragma once

#include <functional>
#include <string>

namespace app {

/**
 * InitializeHttp() needs to be called (globally)
 *
 * Returns:
 *   true if initialization succeeded, false otherwise
 */
bool InitializeHttp();

/**
 * GoOnline requests internet access from the system.  This also ensures that Nintendo
 * servers are reachable.
 * 
 * Returns:
 *   true if online, false if not.
 */
bool GoOnline();

/**
 * Determines if the user has a Nintendo Service Account available and Nintendo hasn't
 * banned the user from using network services.
 *
 * Returns:
 *   true if available, false if not.
 */
bool IsUserNintendoServiceAccountAvailable();

/**
 * Shutdown() needs to be called (globally) once we are done.
 *
 * Will shutdown the underlying Switch libraries and free the memory pools
 * associated with them Only call this once all the http requests have been
 * finished
 *
 * Returns:
 *   true if shutdown succeeded, false otherwise
 */
bool ShutdownHttp();

std::string PrepareCallbackUrlData(const std::string& callbackUrl, const std::string& callbackPrefix);

}  // namespace app
