#pragma once

#include <nn/os.h>
#include <nn/web.h>

#include <map>
#include <string>

namespace app {
struct OnlineWebExitData {
  std::string exitUrl;
  std::map<std::string, std::string> exitCallbackParameters;
  nn::web::WebExitReason reason;
};

std::string GenerateStarshotUrl(const std::string& deviceId, const std::string& oauthToken,
  const std::string& refreshToken, bool chattingAllowed, const std::string& context);

OnlineWebExitData DisplayOnlineWebPage(const std::string& url) NN_NOEXCEPT;
}  // namespace app
