﻿#include "app/ugc.hpp"

#include <nn/pctl.h>

// https://developer.nintendo.com/html/online-docs/g1kr9vj6-en/Packages/SDK/NintendoSDK/Documents/Api/HtmlNX/namespacenn_1_1pctl.html#details
//
// To test users with restriction boot the devkit into Home mode and then you can go to Sytem Settings and enable
// Parental Controls.  Select the Child restriction or whichever one makes sense for the testing.
//
// We should eventually check this setting every time we go to the channel page but because of the limitations
// we have in doing IPC with the WebApplet we can't.

bool app::StartChatting() NN_NOEXCEPT {
  return nn::pctl::TryBeginFreeCommunication(true);
}

void app::EndChatting() NN_NOEXCEPT {
  nn::pctl::EndFreeCommunication();
}
