# PlayStation 4 / 5 App Shell

A thin wrapper application that runs the Twitch TV web app (starshot) on
PlayStation devices.

## Setup

### Requirements

Playstation development requires a windows laptop running Visual Studio with the
Tachyon mono-repo pulled down and a Sony Developer Portal account.

- Windows 10
- [Visual Studio Professional license](https://itmarketplace.corp.amazon.com/detail_pages/260)

### Preparing Your Environment

1. Follow the instructions for
   [General Windows Environment Setup](../general-windows-environment-setup.md)
1. Clone the [tachyon repo](https://git.xarth.tv/emerging-platforms/tachyon)
1. Install dependencies:
   - Install yarn from
     [here](https://yarnpkg.com/lang/en/docs/install/#windows-stable) if not
     already installed
     - From a terminal, run the following command:
       > `yarn global add create-react-native-app`
1. Get access to Sony Devnet
   1. Access from home
      - Ask you manager to add your router's public IP to Sony's allowlist
   2. Access from the office
      - Currently not supported due to the proxy servers being down
      - If it were up then you would follow
        [these instructions](https://wiki.xarth.tv/display/CAP/Sony+DevNet+and+PS4+Proxy)
1. Enable .NET framework 3.5 through Windows Features (required for SDK Manager)
   - In Windows, search for "Turn Windows Features on or off" (for how to
     details, see Microsoft Docs)
1. Connect to https://ps4.siedev.net with your SIE user and password. (Ask Dave
   Fishel for access)
1. Download the SDK Manager
1. Start the SDK Manager
   - Setup the Proxy in the SDK Manager if not allowlisted
1. Click install PlayStation SDKs and extra features
   1. Log in to your PSN account
   1. Select the PlayStation 4 tab (make sure you do this or you'll accidentally
      install the wrong toolset)
   1. Click Next
   1. Select the most recent SDK
   1. Default options can be minimized if you don't want documentation locally
      or certain System Update Files.
   1. Check to make sure these options are selected:
      - SDK / Development Tools > Tools for Development > Visual Studio
        Integration
        - Install Publishing/Tools/Publishing Tools
        - SDK / Development Tools > SDK > Video Service SDK > Publishing for
          VideoService SDK
   1. Click Next to install the software
1. Open the Visual Studio solution to build and deploy to PS4 devkit.

### Troubleshooting

**Activation Errors**

1. The PS4 DevKit needs to be re-activated every 90 days through a file
   available from
   [DevNet](https://ps4.siedev.net/hardware/location/o35992/report/).
1. Scroll down to Activate Unit
1. Check the box(es) that correspond to the hardware you want to activate.
1. Click Activate Selected Hardware, save the file on your computer.
1. On Neighborhood for PS4, right-click on your DevKit and select the
   Activate... option and choose the file you downloaded in the previous step.

![re-activate](../static-docfiles/re-activate.png)

## Adding PS5 Support

There is some partial work towards PS5 in branches for
https://git.xarth.tv/twitch-apps/Starshot-Playstation. The project codename for
PS5 is Prospero.

_Adapted from
[PS4 Environment Setup](https://wiki.xarth.tv/display/CAP/PS4+Environment+Setup)_
